/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh      mbox;
Particles part[4]; // particles
/******************************************************************************/
void InitPre()
{
   App.name="Particles";
   App.flag=APP_FULL_TOGGLE|APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");

   D.full(true);
   Cam.dist=2;
}
/******************************************************************************/
Bool Init()
{
   // create mesh box
   mbox.create(1).B(0).create(Box(4),VTX_TX0|VTX_NRM|VTX_TNG).reverse();
   mbox.setMaterial(Materials("../data/mtrl/brick/0.mtrl")).setRender().setBox();

   // create particles
   {
      // we'll start with a fire-like particle
      Gfx  *gfx  =Gfxs("../data/gfx/particle/fire.gfx"); // image
      UInt  col  =ARGB(0,40,0,0);                        // color
      Int   num  =30;                                    // number
      Flt   r    =0.1,                                   // radius
            life =1.0,                                   // average life
            vel  =0.2;                                   // random velocity
      Vec   accel(0,1,0);                                // acceleration
      Shape shape(Ball(0.05));                           // particles initial shape

      part[0].create(*gfx,col,num,r,life,vel,accel,shape); // create particles
      part[0].set   (Vec(-0.5,0,0)                      ); // move to the left
      part[0].reset (                                   ); // reset every single particle for random position and other parameters

      // let's set part[1] with different settings, to make it magic-like
      {
         gfx =Gfxs("../data/gfx/particle/fire.gfx");
         col =ARGB(0,0,0,40);
         num =100;
         r   =0.05;
         life=1.0;
         vel =0;
         accel.zero();
         shape=Capsule(0.1,0.4);

         part[1].create(*gfx,col,num,r,life,vel,accel,shape); // create particles
         part[1].reset (                                   ); // reset every single particle
         part[1].func=PARTICLE_SIN;                           // change particles power function to sinus based
      }

      // and now part[2], fountain-like
      {
         gfx =Gfxs("../data/gfx/particle/drop.gfx");
         col =ARGB(150,20,120,200); // part[2] will be rendered in a different way (alpha blended) so make sure to set up alpha value in the color
         num =500;
         r   =0.02;
         life=1.0;
         vel =1.0;
         accel.set(0,-2,0);
         shape=Vec(0,0,0);

         part[2].create(*gfx,col,num,r,life,vel,accel,shape); // create particles
         part[2].set   (Vec(0.5,0,0)                       ); // move to the right
         part[2].vel.set(2,2,0);                              // set initial vector velocity
         part[2].damping=0.98;                                // enable damping
         part[2].reset(                                    ); // reset every single particle
      }

      // part[3], smoke-like
      {
         gfx =Gfxs("../data/gfx/particle/fire.gfx");
         col =ARGB(100,0,0,0); // part[3] will be rendered in a different way (alpha blended) so make sure to set up alpha value in the color
         num =40;
         r   =0.15;
         life=1.5;
         vel =0.2;
         accel.zero();
         shape=Vec(0,0,0);

         part[3].create(*gfx,col,num,r,life,vel,accel,shape); // create particles
         part[3].set   (Vec(-1,0,0)                        ); // move to the left
         part[3].reset (                                   ); // reset every single particle
      }
   }
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.01,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   // modify part[3] position
   Vec2 pos; SinCos(pos.y,pos.x,Tm.time()+PI);
   part[3].set(Vec(pos.x,0,pos.y));

   // update particles
   REPA(part)part[i].update();

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox.draw(MatrixIdentity);
      break;

      case RM_LIGHT:
         LightPoint(30,Vec(0,3,0)).add();
      break;
      
      // particles are rendered in RM_PRT_PAL or RM_PRT_BLN modes
      // the first  one (RM_PRT_PAL) is for particles that are palette based, and take their colors from 'Renderer.particle_palette' texture (you can assign this texure to your custom version with command "Renderer.particle_palette=Gfxs(..)")
      // the second one (RM_PRT_BLN) is for particles with standard alpha blending
      // let's render part[0] and part[1] as pallette based, and part[2] and part[3] with standard alpha blending

      case RM_PRT_PAL: // palette based
         part[0].draw();
         part[1].draw();
      break;

      case RM_PRT_BLN: // alpha blending
         part[2].draw();
         part[3].draw();
      break;
   }
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
